<?php
declare(strict_types=1);

error_reporting(E_ALL);
ini_set('display_errors', '1');

/* ================= CONFIG ================= */

const VK_API_URL = 'https://api.vk.com/method/';
const VK_API_VERSION = '5.131';
const SLEEP_SECONDS = 3;

$accessToken = ''; // VK access token

// Image paths (easy to edit)
$IMAGE_PATHS = [
    __DIR__ . '/1.png',
    __DIR__ . '/2.png',
    __DIR__ . '/3.png',
];

/* ================= VK API ================= */

function vkApi(string $method, array $params = []): array
{
    $params += [
        'v' => VK_API_VERSION,
        'access_token' => $GLOBALS['accessToken'],
    ];

    $ch = curl_init(VK_API_URL . $method);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST           => true,
        CURLOPT_POSTFIELDS     => http_build_query($params),
        CURLOPT_TIMEOUT        => 15,
        CURLOPT_USERAGENT      => 'VK Photo Tool / PHP 8.1',
    ]);

    $response = curl_exec($ch);
    if ($response === false) {
        throw new RuntimeException(curl_error($ch));
    }

    curl_close($ch);

    $json = json_decode($response, true, 512, JSON_THROW_ON_ERROR);

    if (isset($json['error'])) {
        throw new RuntimeException($json['error']['error_msg']);
    }

    return $json['response'];
}

/* ================= Utils ================= */

function logMsg(string $msg): void
{
    echo PHP_EOL . '> ' . $msg;
}

/* ================= Token check ================= */

$profile = vkApi('account.getProfileInfo');
logMsg("ID {$profile['id']} | {$profile['first_name']} {$profile['last_name']}");

/* ================= Album ================= */

$album = vkApi('photos.createAlbum', [
    'title' => 'Auto Album',
    'privacy_view' => 'all',
]);

$albumId = $album['id'];
logMsg("Album created: $albumId");

/* ================= Main loop ================= */

while (true) {

    $server = vkApi('photos.getUploadServer', [
        'album_id' => $albumId,
    ]);

    $files = [];
    $i = 1;

    foreach ($IMAGE_PATHS as $path) {
        if (!file_exists($path)) {
            throw new RuntimeException("File not found: $path");
        }
        $files['file' . $i++] = curl_file_create($path);
    }

    $ch = curl_init($server['upload_url']);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST           => true,
        CURLOPT_POSTFIELDS     => $files,
    ]);

    $uploadResponse = curl_exec($ch);
    curl_close($ch);

    $upload = json_decode($uploadResponse, true, 512, JSON_THROW_ON_ERROR);

    vkApi('photos.save', [
        'album_id'    => $albumId,
        'server'      => $upload['server'],
        'hash'        => $upload['hash'],
        'photos_list' => $upload['photos_list'],
        'caption'     => 'auto upload',
    ]);

    logMsg('Photos uploaded');
    sleep(SLEEP_SECONDS);
}
